<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ProductRequestController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ProductReturnController;

// 🔓 Route Publique (Pas besoin d'être connecté)
Route::post('/login', [AuthController::class, 'login']);

// 🔒 Routes Protégées (Nécessitent le token Sanctum)
Route::middleware('auth:sanctum')->group(function () {

    // --- UTILISATEURS & PROFIL ---
    Route::get('/user', function (Request $request) { return $request->user(); });
    Route::put('/profile', [UserController::class, 'updateProfile']);
    Route::post('/users', [UserController::class, 'store']);
    Route::get('/users', [UserController::class, 'index']);
    Route::put('/users/{id}', [UserController::class, 'update']);
    Route::delete('/users/{id}', [UserController::class, 'destroy']);

    // --- CATÉGORIES ---
    Route::get('/categories', [CategoryController::class, 'index']);
    Route::post('/categories', [CategoryController::class, 'store']);

    // --- PRODUITS (Inventaire) ---
    Route::get('/products/history', [ProductController::class, 'getHistory']);
    Route::get('/products/low-stock', [ProductController::class, 'lowStock']);
    Route::get('/products', [ProductController::class, 'index']);
    Route::get('/stats', [ProductController::class, 'getStats']);
    Route::post('/products', [ProductController::class, 'store']);
    Route::put('/products/{id}', [ProductController::class, 'update']);
    Route::delete('/products/{id}', [ProductController::class, 'destroy']);

    // --- DEMANDES DE SORTIE ---
    Route::post('/requests', [ProductRequestController::class, 'store']);
    Route::get('/requests', [ProductRequestController::class, 'index']);
    Route::patch('/requests/{id}/status', [ProductRequestController::class, 'updateStatus']);

    // --- RETOURS PRODUITS ---
    Route::post('/products/return', [ProductReturnController::class, 'store']);
    Route::get('/products/returns', [ProductReturnController::class, 'index']);
    Route::put('/products/returns/{id}', [ProductReturnController::class, 'update']);
    Route::delete('/products/returns/{id}', [ProductReturnController::class, 'destroy']);

});
