<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void {
        // 1. Ton compte Admin
        User::create([
            'name' => 'Franck Ulrich',
            'email' => 'admin@diginet.ci',
            'password' => Hash::make('password'),
            'role' => 'admin',
            'phone' => '0707070707'
        ]);

        // 2. Des catégories
        $cat = Category::create(['name' => 'Informatique']);
        $pap = Category::create(['name' => 'Papeterie']);

        // 3. Des produits avec TOUTES les colonnes nécessaires
        // Produit 1 : Informatique
        Product::create([
            'reference' => 'REF-SOURIS-001', // Ajouté
            'name' => 'Souris Optique',
            'unit' => 'Pièce',               // Ajouté
            'quantity' => 3, 
            'price' => 5000,
            'category_id' => $cat->id
        ]);

        // Produit 2 : Papeterie (pour tester les unités différentes)
        Product::create([
            'reference' => 'REF-RAME-A4',
            'name' => 'Rame de papier A4',
            'unit' => 'Rame',
            'quantity' => 50,
            'price' => 3500,
            'category_id' => $pap->id
        ]);
    }
}