<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   /**
 * Run the migrations.
 */
public function up(): void
{
    Schema::create('product_requests', function (Blueprint $table) {
        $table->id();
        $table->string('employee_name');
        $table->string('service_name');
        $table->string('site_location');
        $table->string('created_by')->nullable();
        $table->string('unit')->nullable(); // <--- On autorise le vide temporairement
        $table->foreignId('product_id')->constrained()->onDelete('cascade');
        $table->integer('quantity');
        $table->string('status')->default('en_attente');
        $table->timestamps();
    });
}
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('product_requests');
    }
};
