<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
   public function definition(): array {
    return [
        'name' => $this->faker->sentence(2),
        'reference' => 'REF-' . $this->faker->unique()->ean8(),
        'price' => $this->faker->randomFloat(2, 5, 500),
        'quantity' => $this->faker->numberBetween(10, 100),
        'unit' => $this->faker->randomElement(['Unité', 'Mètre', 'Paquet', 'Litre']),
        'category_id' => \App\Models\Category::all()->random()->id,
    ];
}
}
