<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductRequest extends Model
{
    use HasFactory;

    // 1. Définir le nom de la table (si différent du pluriel automatique)
    protected $table = 'product_requests';

    // 2. Autoriser l'enregistrement massif (Mass Assignment)
    protected $fillable = [
        'user_id', // <-- Ajoute cette ligne
        'product_id',
        'quantity',
        'status', // pending, approved, rejected
        'employee_name',
        'service_name',
        'created_by',
        'site_location'
    ];

    /**
     * Relation : Une demande appartient à UN produit.
     * Cela permettra de faire $request->product->name dans ton code.
     */
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
